var yaml_definition = {
  "swagger": "2.0",
  "info": {
    "description": "Communication between App and Sensor network server is almost exclusively based on THD Sever or individual App instances requesting information from the AGR server\nThe only exception is the ability to force an update of data saved on the THD server outside of normal update polling via request from the sensor network server\n\n\nAll request requiring authentification use simple stateless authentification via sending role/password credentials on every request due to ease of implementation on AGR side",
    "version": "1.0.0",
    "title": "Inform@Risk App and Sensor network communication",
    "contact": {
      "email": "sebastian.schroeck@th-deg.de"
    }
  },
  "tags": [
    {
      "name": "THD",
      "description": "Requests sent to THD webserver (App-Backend)"
    },
    {
      "name": "AGR",
      "description": "Requests sent to central sensor data server"
    }
  ],
  "paths": {
    "/sensors/network": {
      "post": {
        "tags": [
          "AGR"
        ],
        "summary": "Return sensor network definition",
        "description": "Return full definition of physical sensor network and associated sensor types",
        "produces": [
          "application/json"
        ],
        "parameters": [
          {
            "in": "body",
            "name": "body",
            "description": "Authentification data",
            "schema": {
              "type": "object",
              "properties": {
                "user": {
                  "type": "string"
                },
                "password": {
                  "type": "string"
                },
                "pid": {
                  "type": "string"
                },
                "pdb": {
                  "type": "string"
                }
              }
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Sensor network definition",
            "schema": {
              "type": "object",
              "properties": {
                "locations": {
                  "type": "array",
                  "items": {
                    "$ref": "#/definitions/Location"
                  }
                },
                "instances": {
                  "type": "array",
                  "items": {
                    "$ref": "#/definitions/Sensor_Instance"
                  }
                },
                "sensor_types": {
                  "type": "array",
                  "items": {
                    "$ref": "#/definitions/Sensor_Type"
                  }
                },
                "measurement_types": {
                  "type": "array",
                  "items": {
                    "$ref": "#/definitions/Measurement_Type"
                  }
                }
              }
            }
          }
        }
      }
    },
    "/sensors/data": {
      "post": {
        "tags": [
          "AGR"
        ],
        "summary": "Returns detailed sensor data",
        "description": "Retrieve detail data including timeline of measured data for specific sensors",
        "produces": [
          "application/json"
        ],
        "parameters": [
          {
            "in": "body",
            "name": "body",
            "schema": {
              "type": "object",
              "properties": {
                "user": {
                  "type": "string"
                },
                "password": {
                  "type": "string"
                },
                "pid": {
                  "type": "string"
                },
                "pdb": {
                  "type": "string"
                },
                "ids": {
                  "type": "array",
                  "items": {
                    "type": "integer"
                  },
                  "example": [
                    2,
                    4,
                    12
                  ]
                },
                "time_span": {
                  "type": "object",
                  "properties": {
                    "start": {
                      "type": "string",
                      "example": "1663676868000",
                      "description": "Unix timestamp in milliseconds"
                    },
                    "end": {
                      "type": "string",
                      "example": "1663679868000",
                      "description": "Unix timestamp in milliseconds"
                    }
                  }
                }
              }
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Array of individual timestamps",
            "schema": {
              "type": "object",
              "properties": {
                "timeline": {
                  "$ref": "#/definitions/Timeline"
                },
                "limits": {
                  "type": "array",
                  "items": {
                    "$ref": "#/definitions/Limit"
                  }
                }
              }
            }
          }
        }
      }
    },
    "/sensors/updated": {
      "post": {
        "tags": [
          "AGR"
        ],
        "summary": "Return time of last sensor network update",
        "description": "Check time of last update of sensor network definition",
        "produces": [
          "application/json"
        ],
        "parameters": [
          {
            "in": "body",
            "name": "body",
            "description": "Authentification data",
            "schema": {
              "type": "object",
              "properties": {
                "user": {
                  "type": "string"
                },
                "password": {
                  "type": "string"
                },
                "pid": {
                  "type": "string"
                },
                "pdb": {
                  "type": "string"
                }
              }
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Unix timestamp in milliseconds of time of last change to sensor network definition",
            "schema": {
              "type": "string",
              "example": "1663676868000"
            }
          }
        }
      }
    },
    "/sensors/update": {
      "post": {
        "tags": [
          "THD"
        ],
        "summary": "Trigger update of sensor network definition data on THD server",
        "produces": [
          "application/json"
        ],
        "parameters": [
          {
            "in": "body",
            "name": "body",
            "description": "Authentification data",
            "schema": {
              "type": "object",
              "properties": {
                "user": {
                  "type": "string"
                },
                "password": {
                  "type": "string"
                },
                "pid": {
                  "type": "string"
                },
                "pdb": {
                  "type": "string"
                }
              }
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Update performed successfully"
          }
        }
      }
    },
    "/sensors/state": {
      "post": {
        "tags": [
          "AGR"
        ],
        "summary": "Return current state for all sensors",
        "description": "Return one of several predefined states describing current operational status of all available sensors",
        "produces": [
          "application/json"
        ],
        "parameters": [
          {
            "in": "body",
            "name": "body",
            "description": "Authentification data",
            "schema": {
              "type": "object",
              "properties": {
                "user": {
                  "type": "string"
                },
                "password": {
                  "type": "string"
                },
                "pid": {
                  "type": "string"
                },
                "pdb": {
                  "type": "string"
                }
              }
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Unix timestamp of time of last change to sensor network definition",
            "schema": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/State"
              },
              "example": [
                {
                  "id": 22,
                  "state": 1
                },
                {
                  "id": 23,
                  "state": 0
                }
              ]
            }
          }
        }
      }
    }
  },
  "definitions": {
    "Limit": {
      "type": "object",
      "properties": {
        "color": {
          "type": "string",
          "description": "Valid RGB hexcode"
        },
        "value": {
          "type": "number",
          "format": "float",
          "example": 137.5
        },
        "label": {
          "type": "string",
          "description": "Short descriptor to be displayed over limit line in chart",
          "example": "Warning Threshold"
        }
      },
      "example": [
        {
          "color": "#FFFF00",
          "value": 75,
          "label": "Warning Threshold"
        },
        {
          "color": "#FF0000",
          "value": 135.5,
          "label": "Alert Threshold"
        }
      ]
    },
    "Timeline": {
      "type": "array",
      "items": {
        "type": "object",
        "properties": {
          "t": {
            "type": "string",
            "example": "1663676868000",
            "description": "Unix timestamp in milliseconds"
          },
          "y": {
            "type": "number",
            "format": "float"
          }
        }
      },
      "example": [
        {
          "t": "1663676868000",
          "y": 25
        },
        {
          "t": "1663676878000",
          "y": 27
        }
      ]
    },
    "State": {
      "type": "object",
      "properties": {
        "id": {
          "type": "integer",
          "description": "Sensor id"
        },
        "status": {
          "type": "integer",
          "description": "Status Code:\n  * 0 - \"Ok\"\n  * 1 - \"Warning\"\n  * 2 - \"Alert\"\n  * 3 - \"Check Sensor\"\n",
          "enum": [
            0,
            1,
            2,
            4
          ]
        }
      }
    },
    "Location": {
      "type": "object",
      "properties": {
        "position": {
          "type": "string",
          "description": "WKT geometry representation in WGS 84/EPSG:4326 ('GPS-Coordinates'), can be either Point/LineString/Polygon",
          "example": "POINT (48.8103 13.5475)"
        },
        "location_id": {
          "type": "integer",
          "description": "Unique identifier for each location where sensor units are elocated"
        },
        "name": {
          "type": "string",
          "description": "Description for displaying on map/detail overview screens",
          "example": "Gathering Point North-East"
        },
        "sensors": {
          "type": "array",
          "description": "list of IDs of all sensors types present at this location",
          "items": {
            "type": "integer"
          }
        }
      }
    },
    "Sensor_Instance": {
      "type": "object",
      "properties": {
        "location_id": {
          "type": "integer",
          "description": "IDs defined in location part of sensor network request"
        },
        "sensortype_id": {
          "type": "integer",
          "description": "IDs defined in sensor types part of sensor network request"
        },
        "measurementtype_id": {
          "type": "integer",
          "description": "IDs defined in measurement types part of sensor network request"
        },
        "timeline_id": {
          "type": "integer",
          "description": "Key used to query value timeline of a single physical measurement unit present in a location (Unique key in foreign database)"
        }
      }
    },
    "Sensor_Type": {
      "type": "object",
      "properties": {
        "sensortype_id": {
          "type": "integer",
          "description": "Fixed number used to reference this type of sensor in various places in network definition"
        },
        "name": {
          "type": "object",
          "description": "JSON object of names for displaying on detail screens and filters with ISO 3166-1 alpha-2 country codes as key values",
          "example": {
            "es": "Spanish name",
            "en": "English name",
            "de": "German name"
          }
        },
        "text": {
          "type": "object",
          "description": "JSON object of full text describing the sensor type for displaying on sensor detail screen with ISO 3166-1 alpha-2 country codes as key values",
          "example": {
            "es": "Full Spanish text including linebreaks/newlines",
            "en": "Full English text including linebreaks/newlines",
            "de": "Full German text including linebreaks/newlines"
          }
        },
        "picture": {
          "type": "string",
          "description": "Picture showing the specific sensor type to display in app in base64 encoding",
          "example": "77+9UE5HChoKAAAACklIRFIAAAd3AAAEGggGAAAAUCfvv70AAArvv71pQ0NQSUNDIFByb2ZpbGUA AEjvv73vv73vv70HVFP....."
        },
        "table": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/Table_Element"
          }
        },
        "measurements": {
          "type": "array",
          "description": "list of IDs of all measurement types taken by this sensor type",
          "items": {
            "type": "integer"
          }
        }
      }
    },
    "Measurement_Type": {
      "type": "object",
      "properties": {
        "measurementtype_id": {
          "type": "integer",
          "description": "Fixed number used to reference this type of measurement taken in various places in network definition"
        },
        "name": {
          "type": "object",
          "description": "JSON object of names for displaying on detail screens and filters with ISO 3166-1 alpha-2 country codes as key values",
          "example": {
            "es": "Spanish name",
            "en": "English name",
            "de": "German name"
          }
        },
        "unit": {
          "type": "string",
          "description": "Description for display in charts",
          "example": "°C"
        }
      }
    },
    "Table_Element": {
      "type": "object",
      "properties": {
        "name": {
          "description": "JSON object of names of a single table entry for details screen with ISO 3166-1 alpha-2 country codes as key values",
          "example": {
            "es": "Spanish name",
            "en": "English name",
            "de": "German name"
          }
        },
        "value": {
          "description": "JSON object of values of a single table entry for details screen with ISO 3166-1 alpha-2 country codes as key values",
          "example": {
            "es": "Spanish value",
            "en": "English value",
            "de": "German value"
          }
        }
      }
    }
  }
}